/******************************************************************************/
//
// This example project was made by Tottel. You can use anything in here for your own projects 
// CURRENT VERSION: v6
//
/******************************************************************************/
// Thank you for purchasing this project.
// You can always contact me for suggestions and remarks. Keep in mind that I plan on updating this project (for free), so: Copy to your own project rather than working in this one.
// 
// The examples include: 
//    - A visual event system that can draw text, particles, lights, shake camera, open doors, toggle object visibility, play sounds, teleport objects.
//    - Triggers that trigger the events. These are trigger zones, but also buttons and items you can pick up.
//    - An basic example world that shows how common things are used separately.
//    - An advanced example world, structured like a game to show more advanced uses.
//    
//
// THERE ARE 2 APPLICATIONS IN THIS PROJECT
//    - EEHelper:
//          - Is a helper application that you can launch to visualize event connections in the world-editor. 
//          - A red line means it references the target object.
//          - A green line means it's being referenced by the target object.
//          - You can add the APP_HIDDEN flag in the InitPre if you don't wish to have the window open. You can close the process in the task manager.
//          - Minimizing the window seems to stop the updating. Just open the window, then click on the editor and you're good to go.
//
//    - VisualEventSystem:
//          - The main project, run in debug mode to visualize the triggers
//
//
// HOW TO CREATE YOUR OWN EVENT:
//
//    - Create a new ObjectClass under Content/EVENT_SYSTEM/Objects. Add parameters that you would like to use.
//    - Duplicate one of the other Event objects under Content/EVENT_SYSTEM/Usable and change the class (under params) to the one you've just created.
//    - Create a code file for your Event under Events, and inherit from BaseEvent (call the base class from the constructor)
//          - Override create() to add your own parameters, make sure to call super.create() to load the Duration, Delay and other params.
//          - Override AfterCreate() if necessary (if your object needs to use other objects in the scene). You can use this so you don't have to search for the correct object during play.
//          - Override CallTriggeredAction() and StopTriggeredAction() to define what happens when your event gets called/stopped.
//          - If needed, override update(), make sure to call super.update() if you do.
//          - If needed, override drawPrepare().
//    - In the main code class, add: 
//          - A new ObjMap container for your event objects
//          - use SetObjType in the Init to link the container with your ObjectClass
//    - Make sure the Events can get triggered from the EventGroups. Open up the EventGroup file, copy/paste one of the REPAD loops and change to your own container.
//
//
// HOW TO USE AN EVENT:
// 
//    - First, you need a way to trigger it. Either by an EventTrigger, item-pickup, or button-press; so place any of these in the scene. Optionally, you can set an EventGroup to automatically be called at gamestart.
//    - FOR A TRIGGER: Notice the parameter that asks for an Enter_, Exit_, Inside_EventGroupUID, which are UID values of EventGroups in the scene. They will be called when you enter, exit, or stay inside the trigger.
//    - Drag an EventGroup in the scene (Content/EVENT_SYSTEM/Usable), place it close to the trigger (for clarity) and press CTRL + D (on the EventGroup) to copy the ID value.
//    - Select your trigger and hit CTRL + V in the Enter_, Exit_, Inside_EventGroupUID param to paste the ID. 
//    - Place an Event in the scene and again press CTRL + D (to copy) and CTRL + V to paste it in the OnSwitch1 of the EventGroup object. 
//    - You can add up to 9 events per EventGroup. Have a look at the EventGroup code file; if needed, you can always add more. Eventgroups can also trigger other eventgroups.
//
// HOW TO PLAY BOTH LEVELS:
//
//    - Go into the "Main" code file and change the line that loads the world in "Init()".
// 
// CHANGELOG:
//
// Release v6.:
//     - Crash fix when closing the application.
//    - Removed DoorTrigger. Added a new event OpenDoor which is triggered by a regular Trigger.
//    - Also removed BaseTrigger. There is now only EventTrigger. Simplified the EventTrigger class.
//    - Added a bunch of missing variables in the initializer lists.
//    - Added "final" keyword to a bunch of methods that are not supposed to be overriden.
//    - Added more asserts to check if provided UID counts match the amount of objects found in the scene during start-up.
//    - Added some more events to the Events_2 map.
//    - Fixed PlaySound fade in.
//    - VarAudio now also inherits from VarBase.
//    - PlaySound now also has a Duration.
//    - Removed Duration From RemoveParticles (Removing particles is permanent).
//
// Release v5b:
//    - Compatibility update with latest engine version.
//    - GameCamera can switch between First Person, Third Person and Look-At.
//    - Updated Interaction class to take head pos and direction into account. 
//    - SlidingDoor actor now moves along with the door mesh while opening/closing.
//
// Release v5a.:
//    - Compatibility update with latest engine version.
//    - Made some visual improvements to level 2
//    - Fixed "item" not being visible in the game
//
// Release v5.:
//    - A much more advanced example map, structured like a game to showcase a lot of the functionality.
//    - Added new variable types: VarAudio, VarString, VarPointLight, VarParticles, VarFloat, VarVec. 
//      This gives more control like playing, stopping, pausing, drawing, not drawing, .. at runtime since you operate on "dynamic" variables
//    - Added new events: StopSound, ToggleTrigger, StopDrawText, SetString, SetPointLight, RemoveLight, RemoveParticles, SetFloat, SetVec.
//     - Events now take the new variables as input, which allows for dynamically changing.. everything.
//    - Various renamings in object classes: ID to UID, NextNodeUID to EventGroupUID, IntUID to VarIntUID, BoolUID to VarBoolUID ..
//    - SetInt can clamp the end value if you add or subtract
//    - Added AfterCreate() method to BaseEvent/derived events/other classes to find objects/events during initialization, in stead of during runtime.
//     - Replaced LinkableNode with BaseCheckVariable.
//    - Triggers can also call an event per frame/second.
//    - Improved Elevator class to always end up on the exact goal position in case of lower FPS
//     - Updated documentation
//
// Release v4a.: 
//    - Compatibility update with latest engine versions. 
//    - Removed 'linkable nodes' functionality (being able to link boxes other than an 'eventgroup' to different things). Seriously, that stuff was horribly designed. 
//      Only use EventGroup's to start any events. Period.
//
// Release v4.:
//    - Added new event: ControlElevator which allows you to move a platform that can support a player. Check sample world for usage.
//    - Added MathHelper class for some extra math operations.
//    - Added conditional logic: VarBool, VarInt, SetBool, SetInt, CheckBool, CheckInt. Check sample world for usage
//    - Added linkable nodes (Eventgroup/CheckBool/CheckInt can be chained together). Check sample world for usage.
//    - Buttons can be set to trigger "once"/"infinite times", or just "on every time".
//    - Updated Event_1 world with the new/updated events.
//
// Release v3.:
//    * UPDATED OBJ_BUTTON, OBJ_EVENTTRIGGER and multiple code files
//    * ADDED OBJ_TELEPORTOBJECT, ENUM_BUTTONSTATE
//    - Trigger zones can now trigger two separate eventgroups when entering and when exiting.
//    - Buttons can now trigger two separate eventgroups (toggled on/off).
//    - Added new event: TeleportObject
//    - Updated EEHelper project (Thanks Marbasoft!) to check for connection + work on any world that you open.
//    - Updated Event_1 world with the new/updated events.
//
// Release v2.:
//    - Added BaseEvent class to simplify the event classes and get rid of duplicate code.
//    - Updated every event to inherit from BaseEvent (every event now has a Duration, Active and Delay param as base)
//    - Updated some OBJ_* event classes to handle duration/delay/active, active is set to true by default, so you can optionally add this param to change this.
//    - Update SlidingDoor to also handle temporary (un)locking
//    - Updated the SlidingDoor and ToggleDrawObject examples in the world
//    - Added more comments in the events classes
//
// Release v1.:
//    - Initial Release
//
/******************************************************************************/